//
//  GHPairingCompletion.h
//  standard
//
//  Created by Echeandia, Augie on 8/2/19.
//  Copyright © 2019 Garmin International. All rights reserved.
//

#import <Foundation/Foundation.h>

@class GHDevice;
@protocol GHPairingDelegate;

/**
 *  GHPairingCompletion allows for the control of the last step of the pairing process.
 *  When this object is created the device is effectively paired and is paused waiting for
 *  confirmation that the pairing should complete or reset before finishing. If no
 *  complete or reset command is issued in a reasonable amount of time, the connection is canceled.
 */
@interface GHPairingCompletion : NSObject <NSCoding>

/** The device that is being paired. */
@property (nonatomic, readonly) GHDevice *device;

/**
 *  Completed the pairing.
 *  @param delegate  The GHPairingDelegate to notify.
 */
- (void)complete:(id<GHPairingDelegate>)delegate;

/**
 *  The device is reset to defaults and the pairing is completed afterwards automatically.
 *  @param delegate  The GHPairingDelegate to notify.
 */
- (void)requestReset:(id<GHPairingDelegate>)delegate;

/** NS_UNAVAILABLE */
+ (instancetype)new NS_UNAVAILABLE;

/** NS_UNAVAILABLE */
- (instancetype)init NS_UNAVAILABLE;


@end
